/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.modcompat.integratedcrafting;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;

public class TerminalCraftingOptionRecipeDefinition<T, M>
implements ITerminalCraftingOption<T> {
    private final IngredientComponent<T, M> ingredientComponent;
    private final IRecipeDefinition prioritizedRecipe;

    public TerminalCraftingOptionRecipeDefinition(IngredientComponent<T, M> ingredientComponent, IRecipeDefinition prioritizedRecipe) {
        this.ingredientComponent = ingredientComponent;
        this.prioritizedRecipe = prioritizedRecipe;
    }

    @Override
    public Iterator<T> getOutputs() {
        return this.prioritizedRecipe.getOutput().getInstances(this.ingredientComponent).iterator();
    }

    @Override
    public Collection<IngredientComponent<?, ?>> getOutputComponents() {
        return this.prioritizedRecipe.getOutput().getComponents();
    }

    @Override
    public <T1, M> Collection<T1> getOutputs(IngredientComponent<T1, M> ingredientComponent) {
        return this.prioritizedRecipe.getOutput().getInstances(ingredientComponent);
    }

    @Override
    public Collection<IngredientComponent<?, ?>> getInputComponents() {
        return this.prioritizedRecipe.getInputComponents();
    }

    @Override
    public <T1, M> Collection<T1> getInputs(IngredientComponent<T1, M> ingredientComponent) {
        return this.prioritizedRecipe.getInputs(ingredientComponent).stream().filter(prototype -> !prototype.getAlternatives().isEmpty()).map(prototype -> ((IPrototypedIngredient)Iterables.getFirst((Iterable)prototype.getAlternatives(), null)).getPrototype()).collect(Collectors.toList());
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        return this.ingredientComponent;
    }

    public IRecipeDefinition getRecipe() {
        return this.prioritizedRecipe;
    }

    @Override
    public int compareTo(ITerminalCraftingOption<T> o) {
        if (!(o instanceof TerminalCraftingOptionRecipeDefinition)) {
            throw new IllegalArgumentException("Could not compare TerminalCraftingOptionPrioritizedRecipe to " + o);
        }
        return this.getRecipe().compareTo((Object)((TerminalCraftingOptionRecipeDefinition)o).getRecipe());
    }
}

